<?php
require_once 'db_connect.php';

// Add more pending tasks
$tasks = [
    [
        'title' => 'Maintenance check for Truck #107',
        'description' => 'Perform routine maintenance check on Truck #107 before next assignment',
        'priority' => 'Medium',
        'due_date' => date('Y-m-d', strtotime('+2 days')),
        'assignee_id' => 6, // Mechanic
        'status' => 'pending',
        'created_by' => 4 // Dispatch
    ],
    [
        'title' => 'Clean and prepare Van #102',
        'description' => 'Clean and prepare Van #102 for client visit tomorrow',
        'priority' => 'High',
        'due_date' => date('Y-m-d', strtotime('+1 day')),
        'assignee_id' => 7, // Washcrew
        'status' => 'pending',
        'created_by' => 4 // Dispatch
    ],
    [
        'title' => 'Update route documentation',
        'description' => 'Update the route documentation for all active drivers',
        'priority' => 'Low',
        'due_date' => date('Y-m-d', strtotime('+5 days')),
        'assignee_id' => null, // Unassigned
        'status' => 'pending',
        'created_by' => 4 // Dispatch
    ]
];

// Insert tasks
$stmt = $pdo->prepare("INSERT INTO tasks (title, description, priority, due_date, assignee_id, status, created_by) 
                      VALUES (:title, :description, :priority, :due_date, :assignee_id, :status, :created_by)");

foreach ($tasks as $task) {
    $stmt->bindParam(':title', $task['title'], PDO::PARAM_STR);
    $stmt->bindParam(':description', $task['description'], PDO::PARAM_STR);
    $stmt->bindParam(':priority', $task['priority'], PDO::PARAM_STR);
    $stmt->bindParam(':due_date', $task['due_date'], PDO::PARAM_STR);
    $stmt->bindParam(':assignee_id', $task['assignee_id'], $task['assignee_id'] ? PDO::PARAM_INT : PDO::PARAM_NULL);
    $stmt->bindParam(':status', $task['status'], PDO::PARAM_STR);
    $stmt->bindParam(':created_by', $task['created_by'], PDO::PARAM_INT);
    
    $stmt->execute();
    echo "Added task: " . $task['title'] . "\n";
}

// Verify tasks
$stmt = $pdo->query('SELECT * FROM tasks WHERE status = "pending"');
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
print_r($tasks);
?>
