-- Check if test user exists
SET @user_exists = (SELECT COUNT(*) FROM users WHERE user_identifier = 'testuser');

-- If user doesn't exist, create it
SET @sql = IF(@user_exists > 0,
    'SELECT "Test user already exists" AS message',
    'INSERT INTO users (user_identifier, name, email, password, role, status, biometric_enabled, created_at)
     VALUES ("testuser", "Test User", "test@example.com", "1234", "owner", "active", 1, NOW())');

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Update existing test user if it exists
UPDATE users
SET
    password = '1234',
    biometric_enabled = 1,
    status = 'active'
WHERE user_identifier = 'testuser';

-- Show the test user
SELECT id, user_identifier, name, email, password, role, status, biometric_enabled, created_at
FROM users
WHERE user_identifier = 'testuser';
