<?php
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require_once 'db_connect.php';

$userId = verifyRole($conn, 'owner');
if (isset($_POST['condition']) && isset($_POST['threshold'])) {
    $condition = $_POST['condition'];
    $threshold = $_POST['threshold'];
    $stmt = $conn->prepare("INSERT INTO alert_settings (user_id, condition, threshold) VALUES (?, ?, ?)");
    $stmt->execute([$userId, $condition, $threshold]);
    echo json_encode(['success' => true, 'message' => 'Alert setting created', 'data' => ['id' => $conn->lastInsertId(), 'condition' => $condition, 'threshold' => $threshold]]);
} else {
    echo json_encode(['success' => false, 'message' => 'Condition and threshold required']);
}