<?php
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require_once 'db_connect.php';

$userId = verifyRole($conn, 'owner');
if (isset($_POST['name']) && isset($_POST['questions'])) {
    $name = $_POST['name'];
    $description = $_POST['description'] ?? '';
    $questions = $_POST['questions'];
    $stmt = $conn->prepare("INSERT INTO inspection_templates (name, description, questions, created_by) VALUES (?, ?, ?, ?)");
    $stmt->execute([$name, $description, $questions, $userId]);
    echo json_encode(['success' => true, 'message' => 'Template created', 'data' => ['id' => $conn->lastInsertId(), 'name' => $name, 'description' => $description, 'questions' => json_decode($questions)]]);
} else {
    echo json_encode(['success' => false, 'message' => 'Name and questions required']);
}