<?php
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'vehicle_inspection_system';

// Add headers similar to the other db_connect.php for consistency, if needed by scripts including this one.
// It's generally better to have one central db_connect.php if possible.
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password); // Use $pdo
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); // Use $pdo
} catch (PDOException $e) {
    // Echo error but don't exit, let the calling script handle the missing $pdo
    echo json_encode(['success' => false, 'message' => "Database Connection failed in dashboard_owner/db_connect.php: " . $e->getMessage()]);
    // exit; // Removed exit
}

// Note: This function seems specific and might be better placed elsewhere or refactored.
// It also uses a 'token' column in the 'users' table which might not exist.
// Assuming it's needed and the table structure is correct:
function verifyRole($pdo, $requiredRole) { // Use $pdo
    // Check if $pdo is valid before using it
    if (!isset($pdo) || !$pdo instanceof PDO) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Database connection not available for role verification.']);
        exit;
    }

    $headers = getallheaders();
    // Extract Bearer token
    $authHeader = $headers['Authorization'] ?? '';
     if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $token = $matches[1];
    } else {
        $token = ''; // No valid Bearer token found
    }

    if (empty($token)) {
        http_response_code(401);
        echo json_encode(['success' => false, 'message' => 'Authorization token not found for role verification']);
        exit;
    }

    try {
        // Assuming 'token' column exists in 'users' table for session/auth token
        $stmt = $pdo->prepare("SELECT id, role FROM users WHERE token = ?"); // Use $pdo
        $stmt->execute([$token]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user || $user['role'] !== $requiredRole) {
            http_response_code(403); // Forbidden
            echo json_encode(['success' => false, 'message' => 'Unauthorized or insufficient role']);
            exit;
        }
        return $user['id']; // Return user ID on successful verification
    } catch (PDOException $e) {
         http_response_code(500);
         echo json_encode(['success' => false, 'message' => 'Database error during role verification: ' . $e->getMessage()]);
         exit;
    }
}
