<?php
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require_once 'db_connect.php';

$userId = verifyRole($conn, 'owner');
if (isset($_POST['templateId']) && isset($_POST['name']) && isset($_POST['questions'])) {
    $templateId = $_POST['templateId'];
    $name = $_POST['name'];
    $description = $_POST['description'] ?? '';
    $questions = $_POST['questions'];
    $stmt = $conn->prepare("UPDATE inspection_templates SET name = ?, description = ?, questions = ? WHERE id = ? AND created_by = ?");
    $stmt->execute([$name, $description, $questions, $templateId, $userId]);
    echo json_encode(['success' => true, 'message' => 'Template updated', 'data' => ['id' => $templateId, 'name' => $name, 'description' => $description, 'questions' => json_decode($questions)]]);
} else {
    echo json_encode(['success' => false, 'message' => 'Template ID, name, and questions required']);
}