<?php
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require_once 'db_connect.php';

$userId = verifyRole($conn, 'owner');
if (isset($_POST['userId']) && !empty($_POST)) {
    $userIdToEdit = $_POST['userId'];
    unset($_POST['userId']);
    $set = '';
    $params = [];
    foreach ($_POST as $key => $value) {
        $set .= "$key = ?, ";
        $params[] = $value;
    }
    $set = rtrim($set, ', ');
    $params[] = $userIdToEdit;
    $stmt = $conn->prepare("UPDATE users SET $set WHERE id = ?");
    $stmt->execute($params);
    echo json_encode(['success' => true, 'message' => 'User updated successfully', 'data' => array_merge($_POST, ['id' => $userIdToEdit])]);
} else {
    echo json_encode(['success' => false, 'message' => 'User ID and data are required']);
}