<?php
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

/* require_once 'db_connect.php';

$userId = verifyRole($conn, 'owner');
if (isset($_POST['title']) && isset($_POST['type'])) {
    $title = $_POST['title'];
    $type = $_POST['type'];
    $details = $_POST['details'] ?? '';
    $data = json_encode(['details' => $details]); // Simplified for demo
    $stmt = $conn->prepare("INSERT INTO reports (title, type, generated_by, data) VALUES (?, ?, ?, ?)");
    $stmt->execute([$title, $type, $userId, $data]);
    echo json_encode(['success' => true, 'message' => 'Report generated', 'data' => ['id' => $conn->lastInsertId(), 'title' => $title, 'type' => $type]]);
} else {
    echo json_encode(['success' => false, 'message' => 'Title and type required']);
} */
include 'db_connect.php';

$data = json_decode(file_get_contents("php://input"), true);
$title = $data['title'];
$type = $data['type'];

$sql = "INSERT INTO reports (title, type, generated_by, data) VALUES (?, ?, 1, '{}')";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $title, $type);

if ($stmt->execute()) {
    $reportId = $stmt->insert_id;
    echo json_encode(['success' => true, 'data' => ['id' => $reportId, 'title' => $title, 'type' => $type, 'created_at' => date('Y-m-d H:i:s')]]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to generate report']);
}
$stmt->close();
$conn->close();