<?php
/* header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

$servername = "localhost";
$username = "root";
$password = "";
$dbname = "vehicle_inspection_system";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$sql = "SELECT id, name, plate, image, yard_id, status, created_at, updated_at FROM vehicles";
$result = $conn->query($sql);

$assets = array();

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $assets[] = $row;
    }
}

echo json_encode($assets);

$conn->close(); */
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");
include 'db_connect.php'; // Provides $pdo connection object

try {
    $sql = "SELECT v.id, v.name, v.plate, v.status, y.name as yard_name
            FROM vehicles v
            LEFT JOIN yards y ON v.yard_id = y.id";

    // Prepare and execute the query using PDO
    $stmt = $pdo->prepare($sql);
    $stmt->execute();

    // Fetch all results
    $assets = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Return success response with data
    echo json_encode(['success' => true, 'data' => $assets]);

} catch (PDOException $e) {
    // Return error response if something goes wrong
    http_response_code(500); // Internal Server Error
    echo json_encode([
        'success' => false,
        'message' => 'Database error while fetching assets: ' . $e->getMessage()
    ]);
}
$pdo = null;
// No need to explicitly close PDO connection like $conn->close();
// $pdo = null; // Optional: Can explicitly close if needed before script end.
?>
