<?php
/* header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

$servername = "localhost";
$username = "root";
$password = "";
$dbname = "vehicle_inspection_system";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$sql = "SELECT id, category_id, name FROM subcategories";
$result = $conn->query($sql);

$defects = array();

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $defects[] = $row;
    }
}

echo json_encode($defects);

$conn->close(); */
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request for CORS
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    // Headers are already set at the top or in db_connect.php
    http_response_code(200); // Respond with OK status
    exit; // Stop script execution for OPTIONS request
}

require_once __DIR__ . '/db_connect.php'; // Use __DIR__ for reliability

// Check if $pdo is available after including db_connect.php
if (!isset($pdo) || !$pdo instanceof PDO) {
     http_response_code(500);
     echo json_encode([
         'success' => false,
         'message' => 'Database connection object ($pdo) is not available in getDefects.php.'
     ]);
     exit;
}

try {
    // Verify role using the $pdo connection (Uncomment if needed)
    // Note: Ensure the 'verifyRole' function and the required role are correct.
    // $userId = verifyRole($pdo, 'owner'); // Use $pdo

    // SQL query to fetch defects (vehicle issues)
    $sql = "SELECT vi.id, vi.details, vi.reported_at, v.name as vehicle_name, u.name as reporter_name
            FROM vehicle_issues vi
            JOIN vehicles v ON vi.vehicle_id = v.id
            LEFT JOIN users u ON vi.id = u.id
            ORDER BY vi.reported_at DESC"; // Added status, reported_at, reporter_name and ordering

    // Prepare and execute the query using PDO
    $stmt = $pdo->prepare($sql);
    $stmt->execute();

    // Fetch all results
    $defects = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Return success response with data
    echo json_encode(['success' => true, 'data' => $defects]);

} catch (PDOException $e) {
    http_response_code(500); // Internal Server Error
    echo json_encode([
        'success' => false,
        'message' => 'Database error while fetching defects: ' . $e->getMessage()
    ]);
} catch (Exception $e) { // Catch potential errors from verifyRole if uncommented
    if (http_response_code() === 200) {
       http_response_code(401);
    }
    // Error message is already echoed by verifyRole
}

// No need to explicitly close PDO connection
?>
