<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

require_once './db_connect.php'; // Corrected path assuming it's one level up

// Handle OPTIONS request for CORS preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Ensure $pdo is available from db_connect.php
if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection is not available.']);
    exit();
}

// --- Authentication/Authorization ---
// Assuming verifyRole is defined elsewhere or in db_connect.php and uses $pdo
// In a real app, ensure verifyRole exists and handles errors/exit appropriately
// For now, let's assume it returns a valid user ID or handles unauthorized access
// $userId = verifyRole($pdo, 'owner');
// Placeholder if verifyRole isn't implemented/available:
// Replace with actual user ID retrieval based on session/token if verifyRole is not used
// For testing, we might hardcode or fetch from a session if applicable.
// If authentication is handled by the interceptor + token validation in db_connect.php,
// you might need a function there to get the user ID from the validated token.
// Let's assume for now we need the user ID of the logged-in owner.
// We'll use a placeholder ID. Replace this with your actual auth logic.
$userId = 1; // <<< Replace with actual authenticated user ID retrieval logic

try {
    // Use $pdo for preparing the statement
    // Fetch templates created by the specific owner (adjust logic if templates are global)
    $stmt = $pdo->prepare("SELECT `id`, `name`, `description` FROM `inspection_templates`"); // Removed `questions` for brevity unless needed for selection, removed WHERE clause for now to show all templates
    // If you only want templates created by the owner:
    // $stmt = $pdo->prepare("SELECT `id`, `name`, `description` FROM `inspection_templates` WHERE `created_by` = ?");
    
    $stmt->execute(); // No parameters needed if fetching all
    // If using WHERE created_by:
    // $stmt->execute([$userId]);

    $templates = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Return templates with success status
    echo json_encode(['success' => true, 'data' => $templates]);

} catch (PDOException $e) {
    http_response_code(500);
    error_log("Database Error: " . $e->getMessage()); // Log error
    echo json_encode(['success' => false, 'message' => 'Failed to retrieve inspection templates.']);
    exit();
}
?>
