<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request for CORS
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    // Headers are already set at the top or in db_connect.php
    http_response_code(200); // Respond with OK status
    exit; // Stop script execution for OPTIONS request
}

require_once __DIR__ . '/db_connect.php'; // Use __DIR__ for reliability

// Check if $pdo is available after including db_connect.php
if (!isset($pdo) || !$pdo instanceof PDO) {
     http_response_code(500);
     echo json_encode([
         'success' => false,
         'message' => 'Database connection object ($pdo) is not available in getUserList.php.'
     ]);
     exit;
}

try {
    // Verify role using the $pdo connection (Uncomment if needed)
    // Note: Ensure the 'verifyRole' function and the required role are correct.
    // $userId = verifyRole($pdo, 'owner'); // Use $pdo

    // SQL query to fetch users - added email, created_at for potential use in frontend
    $sql = "SELECT id, name, email, role, status, created_at FROM users ORDER BY name ASC"; 

    // Prepare and execute the query using PDO
    $stmt = $pdo->prepare($sql);
    $stmt->execute();

    // Fetch all results
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Always return success true with data as an array (even if empty)
    echo json_encode(['success' => true, 'data' => $users]);

} catch (PDOException $e) {
    http_response_code(500); // Internal Server Error
    // Return success false and an empty array for data in case of error
    echo json_encode([
        'success' => false,
        'message' => 'Database error while fetching users: ' . $e->getMessage(),
        'data' => [] // Ensure data is always an array on error too
    ]);
} catch (Exception $e) { // Catch potential errors from verifyRole if uncommented
    if (http_response_code() === 200) {
       http_response_code(401);
    }
     echo json_encode([
        'success' => false,
        'message' => 'Authorization or role verification error: ' . $e->getMessage(),
        'data' => [] // Ensure data is always an array
    ]);
}

// No need for $conn->close(); with PDO
?>
