<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");
require 'db.php'; // Include the database connection

// Function to get all categories with their subcategories
function getInspectionCategories($pdo) {
    try {
        $query = "
            SELECT c.id AS category_id, c.name AS category_name, 
                   s.id AS subcategory_id, s.name AS subcategory_name
            FROM Categories c
            LEFT JOIN Subcategories s ON c.id = s.category_id
            ORDER BY c.id, s.id
        ";
        $stmt = $pdo->prepare($query);
        $stmt->execute();
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Organize data into a structured format
        $categories = [];
        foreach ($results as $row) {
            $categoryId = $row['category_id'];
            if (!isset($categories[$categoryId])) {
                $categories[$categoryId] = [
                    'id' => $categoryId,
                    'name' => $row['category_name'],
                    'subcategories' => []
                ];
            }
            if ($row['subcategory_id']) {
                $categories[$categoryId]['subcategories'][] = [
                    'id' => $row['subcategory_id'],
                    'name' => $row['subcategory_name']
                ];
            }
        }
        return array_values($categories); // Convert to indexed array for JSON
    } catch (PDOException $e) {
        return ['error' => $e->getMessage()];
    }
}

// Handle GET request
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'getInspectionCategories') {
    $categories = getInspectionCategories($pdo);
    echo json_encode($categories);
} else {
    echo json_encode(['error' => 'Invalid request']);
}
?>