<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");
include 'db_connect.php';

$data = json_decode(file_get_contents("php://input"), true);
$subject = $data['subject'];
$description = $data['description'];

$sql = "INSERT INTO support_tickets (subject, description, status) VALUES (?, ?, 'open')";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $subject, $description);

if ($stmt->execute()) {
    $ticketId = $stmt->insert_id;
    echo json_encode(['success' => true, 'data' => ['id' => $ticketId, 'subject' => $subject, 'status' => 'open']]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to submit request']);
}
$stmt->close();
$conn->close();
?>