<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db_connect.php';

// Set content type to HTML for better readability in browser
header('Content-Type: text/html');

echo "<h1>WashCrew Users Debug</h1>";

try {
    // Get all users with role containing 'wash'
    $stmt = $pdo->prepare("SELECT id, name, email, role, status, created_at, created_by FROM users WHERE role LIKE '%wash%'");
    $stmt->execute();
    $washcrewUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>Users with 'wash' in role (" . count($washcrewUsers) . " found)</h2>";
    
    if (count($washcrewUsers) > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Status</th><th>Created At</th><th>Created By</th></tr>";
        
        foreach ($washcrewUsers as $user) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($user['id']) . "</td>";
            echo "<td>" . htmlspecialchars($user['name']) . "</td>";
            echo "<td>" . htmlspecialchars($user['email']) . "</td>";
            echo "<td>" . htmlspecialchars($user['role']) . "</td>";
            echo "<td>" . htmlspecialchars($user['status']) . "</td>";
            echo "<td>" . htmlspecialchars($user['created_at']) . "</td>";
            echo "<td>" . htmlspecialchars($user['created_by'] ? $user['created_by'] : 'NULL') . "</td>";
            echo "</tr>";
        }
        
        echo "</table>";
    } else {
        echo "<p>No users found with 'wash' in role.</p>";
    }
    
    // Get all roles in the database
    $stmt = $pdo->prepare("SELECT DISTINCT role FROM users ORDER BY role");
    $stmt->execute();
    $roles = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "<h2>All roles in database</h2>";
    echo "<ul>";
    foreach ($roles as $role) {
        echo "<li>" . htmlspecialchars($role) . "</li>";
    }
    echo "</ul>";
    
    // Add a form to fix washcrew roles
    echo "<h2>Fix WashCrew Roles</h2>";
    echo "<form method='post' action='fix_washcrew_roles.php'>";
    echo "<p>Click the button below to update all users with roles like 'WashCrew', 'Wash Crew', etc. to have the standardized role 'washcrew'.</p>";
    echo "<input type='submit' value='Fix WashCrew Roles'>";
    echo "</form>";
    
} catch (PDOException $e) {
    echo "<h2>Error</h2>";
    echo "<p>Database error: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
