<?php
require_once '../db_connect.php';
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 7; // Hardcoding Dispatcher One (ID 7) for now, replace with actual auth
$user_role = 'dispatch'; 
// --- End Authentication Placeholder ---

if ($method == 'GET') {
    // Fetch chat history
    try {
        $driver_identifier_filter = isset($_GET['driver_id']) ? $_GET['driver_id'] : null;
        $driver_id_filter = null;

        // Find the driver's user ID if an identifier is provided
        if ($driver_identifier_filter) {
            $stmt_driver = $pdo->prepare("SELECT id FROM users WHERE user_identifier = :identifier AND role = 'driver'");
            $stmt_driver->bindParam(':identifier', $driver_identifier_filter, PDO::PARAM_STR);
            $stmt_driver->execute();
            $driver = $stmt_driver->fetch(PDO::FETCH_ASSOC);
            
            if ($driver) {
                $driver_id_filter = $driver['id'];
            } else {
                // Handle case where driver identifier is invalid
                echo json_encode([]);
                exit();
            }
        }

        // Base SQL query
        $sql = "SELECT 
                c.id, 
                c.message_text, 
                c.sent_at, 
                sender.role AS sender_role,
                sender.name AS sender_name,
                recipient.name AS recipient_name,
                sender.user_identifier AS sender_identifier,
                recipient.user_identifier AS recipient_identifier,
                CASE WHEN sender.role = 'driver' THEN sender.user_identifier ELSE recipient.user_identifier END AS driver_identifier,
                CASE WHEN sender.role = 'driver' THEN sender.name ELSE recipient.name END AS driver_name
            FROM communications c
            JOIN users sender ON c.sender_user_id = sender.id
            LEFT JOIN users recipient ON c.recipient_user_id = recipient.id
            WHERE (c.sender_user_id = :user_id OR c.recipient_user_id = :user_id)";

        $params = [':user_id' => $user_id];

        if ($driver_id_filter) {
            // Filter for messages involving the specific driver
            $sql .= " AND (c.sender_user_id = :driver_id OR c.recipient_user_id = :driver_id)";
            $params[':driver_id'] = $driver_id_filter;
        }
        
        $sql .= " ORDER BY c.sent_at ASC"; // Order chronologically

        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        
        $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Return the messages as JSON
        echo json_encode($messages);
        
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }
} elseif ($method == 'POST') {
    // Save a new message sent by the dispatcher
    try {
        if ($user_role !== 'dispatch') {
            http_response_code(403);
            echo json_encode(['error' => 'Only dispatchers can send messages via this endpoint.']);
            exit();
        }
        
        $data = json_decode(file_get_contents('php://input'), true);
        $recipient_identifier = isset($data['recipient_user_identifier']) ? $data['recipient_user_identifier'] : null;
        $message_text = isset($data['message_text']) ? $data['message_text'] : null;
        
        if (!$recipient_identifier || !$message_text) {
            http_response_code(400);
            echo json_encode(['error' => 'Missing recipient identifier or message text.']);
            exit();
        }
        
        // Find recipient user ID
        $stmt_recipient = $pdo->prepare("SELECT id FROM users WHERE user_identifier = :identifier");
        $stmt_recipient->bindParam(':identifier', $recipient_identifier, PDO::PARAM_STR);
        $stmt_recipient->execute();
        $recipient = $stmt_recipient->fetch(PDO::FETCH_ASSOC);
        
        if (!$recipient) {
            http_response_code(404);
            echo json_encode(['error' => 'Recipient user not found.']);
            exit();
        }
        
        $recipient_id = $recipient['id'];
        $sender_role = 'dispatch';
        
        // Insert the message
        $sql = "INSERT INTO communications (sender_user_id, recipient_user_id, sender_role, message_text, sent_at) 
                VALUES (:sender_id, :recipient_id, :sender_role, :message_text, NOW())";
                
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':sender_id', $user_id, PDO::PARAM_INT);
        $stmt->bindParam(':recipient_id', $recipient_id, PDO::PARAM_INT);
        $stmt->bindParam(':sender_role', $sender_role, PDO::PARAM_STR);
        $stmt->bindParam(':message_text', $message_text, PDO::PARAM_STR);
        $stmt->execute();
        
        $message_id = $pdo->lastInsertId();
        
        echo json_encode([
            'success' => true, 
            'message' => 'Message sent successfully.', 
            'message_id' => $message_id
        ]);
        
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}
?>
