<?php
require_once '../db_connect.php';
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 7; // Hardcoding Dispatcher One (ID 7) for now, replace with actual auth
$user_role = 'dispatch'; 
// --- End Authentication Placeholder ---

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
    exit;
}

try {
    // Get all vehicles with their latest location
    $sql = "SELECT 
                v.id,
                v.identifier,
                v.type,
                v.status,
                v.license_plate,
                vl.latitude,
                vl.longitude,
                vl.timestamp as location_timestamp,
                u.name as driver_name,
                u.id as driver_id
            FROM vehicles v
            LEFT JOIN (
                SELECT vehicle_id, latitude, longitude, timestamp
                FROM vehicle_locations vl1
                WHERE timestamp = (
                    SELECT MAX(timestamp)
                    FROM vehicle_locations vl2
                    WHERE vl1.vehicle_id = vl2.vehicle_id
                )
            ) vl ON v.id = vl.vehicle_id
            LEFT JOIN users u ON v.assigned_driver_id = u.id
            ORDER BY v.identifier";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    
    $vehicles = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // If no vehicles found in the database, return sample data
    if (empty($vehicles)) {
        $vehicles = getSampleVehicleLocations();
    } else {
        // Format the data for the frontend
        foreach ($vehicles as &$vehicle) {
            // If no location data, assign random coordinates for demo purposes
            if (empty($vehicle['latitude']) || empty($vehicle['longitude'])) {
                // Generate random coordinates around a central point (e.g., company HQ)
                // For demo purposes, using coordinates around central US
                $centerLat = 39.8283; // Central US latitude
                $centerLng = -98.5795; // Central US longitude
                $radius = 5; // Radius in degrees
                
                $vehicle['latitude'] = $centerLat + (mt_rand(-10000, 10000) / 10000) * $radius;
                $vehicle['longitude'] = $centerLng + (mt_rand(-10000, 10000) / 10000) * $radius;
                $vehicle['location_timestamp'] = date('Y-m-d H:i:s');
            }
            
            // Add a display name for the map
            $vehicle['display_name'] = $vehicle['type'] . ' #' . $vehicle['identifier'];
            
            // Add a color based on status
            switch ($vehicle['status']) {
                case 'available':
                    $vehicle['color'] = '#4CAF50'; // Green
                    break;
                case 'in_use':
                    $vehicle['color'] = '#2196F3'; // Blue
                    break;
                case 'maintenance':
                    $vehicle['color'] = '#9C27B0'; // Purple
                    break;
                case 'out_of_service':
                    $vehicle['color'] = '#F44336'; // Red
                    break;
                default:
                    $vehicle['color'] = '#757575'; // Grey
            }
        }
    }
    
    echo json_encode($vehicles);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}

// Function to generate sample vehicle locations if no data in database
function getSampleVehicleLocations() {
    // Sample data centered around central US
    $centerLat = 39.8283;
    $centerLng = -98.5795;
    $radius = 5;
    
    return [
        [
            'id' => 1,
            'identifier' => '101',
            'type' => 'Truck',
            'status' => 'in_use',
            'license_plate' => 'ABC123',
            'latitude' => $centerLat + 0.5,
            'longitude' => $centerLng + 0.8,
            'location_timestamp' => date('Y-m-d H:i:s'),
            'driver_name' => 'John Smith',
            'driver_id' => 10,
            'display_name' => 'Truck #101',
            'color' => '#2196F3'
        ],
        [
            'id' => 2,
            'identifier' => '102',
            'type' => 'Van',
            'status' => 'available',
            'license_plate' => 'DEF456',
            'latitude' => $centerLat - 0.3,
            'longitude' => $centerLng + 0.2,
            'location_timestamp' => date('Y-m-d H:i:s'),
            'driver_name' => null,
            'driver_id' => null,
            'display_name' => 'Van #102',
            'color' => '#4CAF50'
        ],
        [
            'id' => 3,
            'identifier' => '103',
            'type' => 'Truck',
            'status' => 'maintenance',
            'license_plate' => 'GHI789',
            'latitude' => $centerLat + 0.1,
            'longitude' => $centerLng - 0.5,
            'location_timestamp' => date('Y-m-d H:i:s'),
            'driver_name' => null,
            'driver_id' => null,
            'display_name' => 'Truck #103',
            'color' => '#9C27B0'
        ],
        [
            'id' => 4,
            'identifier' => '104',
            'type' => 'SUV',
            'status' => 'out_of_service',
            'license_plate' => 'JKL012',
            'latitude' => $centerLat - 0.7,
            'longitude' => $centerLng - 0.3,
            'location_timestamp' => date('Y-m-d H:i:s'),
            'driver_name' => null,
            'driver_id' => null,
            'display_name' => 'SUV #104',
            'color' => '#F44336'
        ],
        [
            'id' => 5,
            'identifier' => '105',
            'type' => 'Truck',
            'status' => 'in_use',
            'license_plate' => 'MNO345',
            'latitude' => $centerLat + 0.9,
            'longitude' => $centerLng + 0.4,
            'location_timestamp' => date('Y-m-d H:i:s'),
            'driver_name' => 'Sarah Johnson',
            'driver_id' => 11,
            'display_name' => 'Truck #105',
            'color' => '#2196F3'
        ]
    ];
}
?>
