<?php
require_once '../db_connect.php';
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
 $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
//$user_id = 2; // Hardcoding Driver Alice Brown (ID 2) for now, replace with actual auth
$user_role = 'driver'; 
// --- End Authentication Placeholder ---

if ($method == 'GET') {
    // Ensure the user is a driver and has an ID
    if (!$user_id || $user_role !== 'driver') {
        http_response_code(403); // Forbidden
        echo json_encode(['error' => 'Access denied.']);
        exit();
    }

    try {
        // Find the dispatcher's ID (assuming one dispatcher for simplicity)
        $stmt_dispatch = $pdo->prepare("SELECT id FROM users WHERE role = 'dispatch' LIMIT 1");
        $stmt_dispatch->execute();
        $dispatcher = $stmt_dispatch->fetch(PDO::FETCH_ASSOC);
        
        if (!$dispatcher) {
            // If no dispatcher found, return empty array
            echo json_encode([]);
            exit();
        }
        
        $dispatcher_id = $dispatcher['id'];
        
        // Query to fetch chat history
        $sql = "SELECT 
                    c.id, 
                    c.message_text, 
                    c.sent_at, 
                    sender.role AS sender_role
                FROM communications c
                JOIN users sender ON c.sender_user_id = sender.id
                WHERE (c.sender_user_id = :user_id AND c.recipient_user_id = :dispatcher_id) 
                   OR (c.sender_user_id = :dispatcher_id AND c.recipient_user_id = :user_id)
                ORDER BY c.sent_at ASC";
                
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
        $stmt->bindParam(':dispatcher_id', $dispatcher_id, PDO::PARAM_INT);
        $stmt->execute();
        
        $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Return the messages as JSON
        echo json_encode($messages);
        
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }
} elseif ($method == 'POST') {
    // Save a new message sent by the driver TO dispatch
    if ($user_role !== 'driver') {
        http_response_code(403); 
        echo json_encode(['error' => 'Only drivers can send messages via this endpoint.']);
        exit();
    }
    
    try {
        $data = json_decode(file_get_contents('php://input'), true);
        $message_text = $data['message_text'] ?? null;
        
        if (!$message_text) {
            http_response_code(400);
            echo json_encode(['error' => 'Missing message text.']);
            exit();
        }
        
        // Find the dispatcher's ID
        $stmt_dispatch = $pdo->prepare("SELECT id FROM users WHERE role = 'dispatch' LIMIT 1");
        $stmt_dispatch->execute();
        $dispatcher = $stmt_dispatch->fetch(PDO::FETCH_ASSOC);
        
        if (!$dispatcher) {
            http_response_code(500);
            echo json_encode(['error' => 'Dispatcher user not found. Cannot send message.']);
            exit();
        }
        
        $dispatcher_id = $dispatcher['id'];
        $sender_role = 'driver';
        
        // Insert the message
        $sql = "INSERT INTO communications (sender_user_id, recipient_user_id, sender_role, message_text, sent_at) 
                VALUES (:sender_id, :recipient_id, :sender_role, :message_text, NOW())";
                
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':sender_id', $user_id, PDO::PARAM_INT);
        $stmt->bindParam(':recipient_id', $dispatcher_id, PDO::PARAM_INT);
        $stmt->bindParam(':sender_role', $sender_role, PDO::PARAM_STR);
        $stmt->bindParam(':message_text', $message_text, PDO::PARAM_STR);
        $stmt->execute();
        
        $message_id = $pdo->lastInsertId();
        
        echo json_encode([
            'success' => true, 
            'message' => 'Message sent successfully.', 
            'message_id' => $message_id
        ]);
        
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}
?>
