<?php
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db_connect.php';

if (isset($_POST['instructionId']) && isset($_POST['status'])) {
    $instructionId = $_POST['instructionId'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("UPDATE dispatch_instructions SET status = ? WHERE id = ?");
    $stmt->execute([$status, $instructionId]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(array('success' => true, 'message' => 'Instruction status updated successfully'));
    } else {
        echo json_encode(array('success' => false, 'message' => 'Error updating instruction status'));
    }
} else {
    echo json_encode(array('success' => false, 'message' => 'Instruction ID and status are required'));
}