<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require_once '../config/database.php';
require_once '../utils/auth.php';

try {
    $categories = [
        [
            'id' => 1,
            'name' => 'Air System & Brakes',
            'subcategories' => [
                ['id' => '1_1', 'name' => 'Air Compressor'],
                ['id' => '1_2', 'name' => 'Air Lines'],
                ['id' => '1_3', 'name' => 'Brake Accessories'],
                ['id' => '1_4', 'name' => 'Brakes (Parking & Service)'],
                ['id' => '1_5', 'name' => 'Brake Connections (Trailer)']
            ]
        ],
        [
            'id' => 2,
            'name' => 'Engine & Drivetrain',
            'subcategories' => [
                ['id' => '2_1', 'name' => 'Belts and Hoses'],
                ['id' => '2_2', 'name' => 'Clutch'],
                ['id' => '2_3', 'name' => 'Drive Line'],
                ['id' => '2_4', 'name' => 'Engine'],
                ['id' => '2_5', 'name' => 'Exhaust'],
                ['id' => '2_6', 'name' => 'Fifth Wheel'],
                ['id' => '2_7', 'name' => 'Fluid Levels'],
                ['id' => '2_8', 'name' => 'Frame and Assembly'],
                ['id' => '2_9', 'name' => 'Transmission']
            ]
        ],
        // Add remaining categories here...
    ];

    echo json_encode([
        'success' => true,
        'categories' => $categories
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}
?>