<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db_connect.php';

// Set content type to HTML for better readability in browser
header('Content-Type: text/html');

echo "<h1>Fix WashCrew Roles</h1>";

try {
    // Find all users with roles that should be 'washcrew'
    $stmt = $pdo->prepare("
        SELECT id, name, email, role 
        FROM users 
        WHERE role LIKE '%wash%' OR role LIKE '%Wash%' OR role LIKE '%WASH%'
    ");
    $stmt->execute();
    $usersToFix = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>Users to fix (" . count($usersToFix) . " found)</h2>";
    
    if (count($usersToFix) > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Old Role</th><th>New Role</th><th>Status</th></tr>";
        
        $updateStmt = $pdo->prepare("UPDATE users SET role = 'washcrew' WHERE id = ?");
        $updatedCount = 0;
        
        foreach ($usersToFix as $user) {
            $updateStmt->execute([$user['id']]);
            $status = $updateStmt->rowCount() > 0 ? 'Updated' : 'No change';
            
            if ($status === 'Updated') {
                $updatedCount++;
            }
            
            echo "<tr>";
            echo "<td>" . htmlspecialchars($user['id']) . "</td>";
            echo "<td>" . htmlspecialchars($user['name']) . "</td>";
            echo "<td>" . htmlspecialchars($user['email']) . "</td>";
            echo "<td>" . htmlspecialchars($user['role']) . "</td>";
            echo "<td>washcrew</td>";
            echo "<td>" . $status . "</td>";
            echo "</tr>";
        }
        
        echo "</table>";
        echo "<p>Updated $updatedCount users to have role 'washcrew'.</p>";
    } else {
        echo "<p>No users found that need fixing.</p>";
    }
    
    // Add a link to go back to the debug page
    echo "<p><a href='debug_washcrew.php'>Go back to WashCrew Debug Page</a></p>";
    
} catch (PDOException $e) {
    echo "<h2>Error</h2>";
    echo "<p>Database error: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
