<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once 'db_connect.php';

try {
    // Check database connection
    if (!isset($pdo) || !$pdo instanceof PDO) {
        throw new Exception("Database connection object not available.");
    }

    // Query to get all regions
    $sql = "SELECT id, name FROM regions ORDER BY name ASC";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    
    $regions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Return success response with regions data
    echo json_encode([
        'success' => true,
        'message' => 'Regions retrieved successfully',
        'data' => $regions
    ]);

} catch (PDOException $e) {
    // Log the error server-side
    error_log('Database error in getRegions.php: ' . $e->getMessage());
    
    // Return error response
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    // Log the error server-side
    error_log('Error in getRegions.php: ' . $e->getMessage());
    
    // Return error response
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}

// Close database connection
$pdo = null;
?>