<?php
// Set CORS headers for all responses
header("Access-Control-Allow-Origin: http://localhost:3000"); // Replace * with specific origin for security
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Max-Age: 3600");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204); // No content for preflight
    exit;
}

// Check if request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendError(405, ['success' => false, 'message' => 'Method not allowed']);
}

// Database connection
require_once './db_connect.php'; // Adjust path if needed

// Get request body
$input = file_get_contents('php://input');
error_log("login.php input: " . $input);
$data = json_decode($input, true);

// Validate input
if (!isset($data['username']) || !isset($data['pin']) || empty(trim($data['username'])) || empty(trim($data['pin']))) {
    sendError(400, ['success' => false, 'message' => 'Username and PIN are required and cannot be empty']);
}

$username = trim($data['username']);
$pin = trim($data['pin']);

error_log("login.php - Username: '$username', PIN: '$pin'");

try {
    // Query user
    $stmt = $pdo->prepare("SELECT id, username, pin, role FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    error_log("login.php - User fetched: " . ($user ? json_encode($user) : 'No user found'));

    if (!$user) {
        sendError(401, ['success' => false, 'message' => 'User not found']);
    }

    // Direct comparison for SHA-256 hashed PINs from frontend
    if ($pin === $user['pin']) {
        // Prepare user data for response
        $userData = [
            'id' => $user['id'],
            'username' => $user['username'],
            'role' => $user['role']
            // Add other needed user fields
        ];

        // Generate token
        $token = bin2hex(random_bytes(32));

        sendResponse(200, [
            'success' => true,
            'message' => 'Login successful',
            'user' => $userData,
            'token' => $token
        ]);
    }

    error_log("login.php - PIN verification failed");
    sendError(401, ['success' => false, 'message' => 'Invalid PIN']);

} catch (Exception $e) {
    error_log("login.php - Error: " . $e->getMessage());
    sendError(500, ['success' => false, 'message' => 'Server error']);
}

// Helper function to send JSON response with status code
function sendResponse($statusCode, $data) {
    http_response_code($statusCode);
    echo json_encode($data);
    exit;
}

// Helper function to send error response with status code
function sendError($statusCode, $data) {
    http_response_code($statusCode);
    echo json_encode($data);
    exit;
}
?>