<?php
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
require_once 'db_connect.php';

if (isset ($_POST['email'])) {
    $email = $_POST['email'];
    $token = bin2hex(random_bytes(16));
    $expiration = time() + (60 * 60); // 1 hour expiration
    $stmt = $conn->prepare("INSERT INTO password_resets (email, token, expiration) VALUES (?, ?, ?)");
    $stmt->execute([$email, $token, $expiration]);
    if ($stmt->rowCount() > 0) {
        echo json_encode(array('success' => true, 'message' => 'Password reset instructions sent to your email'));
    } else {
        echo json_encode(array('success' => false, 'message' => 'Failed to send reset instructions'));
    }
} else {
    echo json_encode(array('success' => false, 'message' => 'Email is required'));
}