<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database connection
require_once 'db_connect.php';

// Get request method
$method = $_SERVER['REQUEST_METHOD'];

// Check for token in headers
$headers = getallheaders();
$token = isset($headers['Authorization']) ? $headers['Authorization'] : '';

// Verify token (simplified for demo)
// In a production environment, implement proper JWT validation
if (empty($token)) {
    echo json_encode(['error' => 'Authentication required']);
    exit;
}

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

if ($method === 'GET') {
    try {
        // Query to fetch active routes with related information
        $sql = "SELECT 
                    r.id AS route_id,
                    r.route_identifier,
                    r.status AS route_status,
                    r.current_location,
                    r.eta,
                    r.destination,
                    r.created_at,
                    r.updated_at,
                    v.id AS vehicle_id,
                    v.vehicle_identifier,
                    v.status AS vehicle_status,
                    u.id AS driver_id,
                    u.name AS driver_name,
                    u.email AS driver_email
                FROM 
                    routes r
                LEFT JOIN 
                    vehicles v ON r.vehicle_id = v.id
                LEFT JOIN 
                    users u ON r.driver_id = u.id
                WHERE 
                    r.status IN ('active', 'delayed', 'completed')
                ORDER BY 
                    r.updated_at DESC";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            $routes = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // Format the data for frontend
            $formattedRoutes = [];
            foreach ($routes as $route) {
                $formattedRoutes[] = [
                    'id' => $route['route_id'],
                    'route_identifier' => $route['route_identifier'],
                    'status' => $route['route_status'],
                    'status_text' => ucfirst($route['route_status']),
                    'current_location_text' => $route['current_location'],
                    'eta_text' => $route['eta'],
                    'destination_location' => $route['destination'],
                    'vehicle_identifier' => $route['vehicle_identifier'],
                    'driver_name' => $route['driver_name'],
                    'created_at' => $route['created_at'],
                    'updated_at' => $route['updated_at']
                ];
            }
            
            echo json_encode($formattedRoutes);
        } else {
            // If no routes found, return empty array
            echo json_encode([]);
        }
    } catch (PDOException $e) {
        echo json_encode(['error' => 'Failed to fetch routes: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['error' => 'Method not allowed']);
}
?>
