<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once 'db_connect.php';

// Set content type to JSON
header('Content-Type: application/json');

try {
    // Check if users table exists
    $tableCheck = $pdo->query("SHOW TABLES LIKE 'users'");
    $tableExists = $tableCheck->rowCount() > 0;
    
    if (!$tableExists) {
        // Create users table
        $pdo->exec("CREATE TABLE users (
            id INT AUTO_INCREMENT PRIMARY KEY,
            name VARCHAR(100) NOT NULL,
            email VARCHAR(100) NOT NULL UNIQUE,
            password VARCHAR(255) NOT NULL,
            role VARCHAR(50) NOT NULL,
            status VARCHAR(20) DEFAULT 'pending',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )");
        
        echo json_encode(['message' => 'Users table created successfully']);
    } else {
        echo json_encode(['message' => 'Users table already exists']);
    }
    
    // Check if there are any users in the table
    $userCheck = $pdo->query("SELECT COUNT(*) as count FROM users");
    $userCount = $userCheck->fetch(PDO::FETCH_ASSOC)['count'];
    
    if ($userCount == 0) {
        // Sample user data
        $users = [
            [
                'name' => 'Admin User',
                'email' => 'admin@example.com',
                'password' => password_hash('admin123', PASSWORD_BCRYPT),
                'role' => 'owner',
                'status' => 'active'
            ],
            [
                'name' => 'Regional Manager',
                'email' => 'regional@example.com',
                'password' => password_hash('regional123', PASSWORD_BCRYPT),
                'role' => 'regional_manager',
                'status' => 'active'
            ],
            [
                'name' => 'Yard Manager',
                'email' => 'yard@example.com',
                'password' => password_hash('yard123', PASSWORD_BCRYPT),
                'role' => 'yard_manager',
                'status' => 'active'
            ],
            [
                'name' => 'Dispatcher',
                'email' => 'dispatch@example.com',
                'password' => password_hash('dispatch123', PASSWORD_BCRYPT),
                'role' => 'dispatcher',
                'status' => 'active'
            ],
            [
                'name' => 'Driver 1',
                'email' => 'driver1@example.com',
                'password' => password_hash('driver123', PASSWORD_BCRYPT),
                'role' => 'driver',
                'status' => 'active'
            ],
            [
                'name' => 'Driver 2',
                'email' => 'driver2@example.com',
                'password' => password_hash('driver123', PASSWORD_BCRYPT),
                'role' => 'driver',
                'status' => 'inactive'
            ],
            [
                'name' => 'Field Rep',
                'email' => 'fieldrep@example.com',
                'password' => password_hash('field123', PASSWORD_BCRYPT),
                'role' => 'field_rep',
                'status' => 'active'
            ],
            [
                'name' => 'Mechanic',
                'email' => 'mechanic@example.com',
                'password' => password_hash('mechanic123', PASSWORD_BCRYPT),
                'role' => 'mechanic',
                'status' => 'active'
            ],
            [
                'name' => 'Wash Crew 1',
                'email' => 'wash1@example.com',
                'password' => password_hash('wash123', PASSWORD_BCRYPT),
                'role' => 'washcrew',
                'status' => 'active'
            ],
            [
                'name' => 'Wash Crew 2',
                'email' => 'wash2@example.com',
                'password' => password_hash('wash123', PASSWORD_BCRYPT),
                'role' => 'washcrew',
                'status' => 'pending'
            ],
            [
                'name' => 'Wash Crew 3',
                'email' => 'wash3@example.com',
                'password' => password_hash('wash123', PASSWORD_BCRYPT),
                'role' => 'washcrew',
                'status' => 'inactive'
            ]
        ];
        
        // Insert sample users
        $stmt = $pdo->prepare("INSERT INTO users (name, email, password, role, status) VALUES (?, ?, ?, ?, ?)");
        
        $insertedCount = 0;
        foreach ($users as $user) {
            $stmt->execute([
                $user['name'],
                $user['email'],
                $user['password'],
                $user['role'],
                $user['status']
            ]);
            $insertedCount++;
        }
        
        echo json_encode(['message' => "$insertedCount sample users added successfully"]);
    } else {
        echo json_encode(['message' => "Users table already has $userCount records"]);
    }
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>
