-- Create vehicles table if it doesn't exist
CREATE TABLE IF NOT EXISTS `vehicles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `identifier` varchar(50) NOT NULL,
  `type` varchar(50) NOT NULL,
  `status` enum('available', 'in_use', 'maintenance', 'out_of_service') NOT NULL DEFAULT 'available',
  `license_plate` varchar(20) DEFAULT NULL,
  `assigned_driver_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `identifier` (`identifier`),
  KEY `assigned_driver_id` (`assigned_driver_id`),
  CONSTRAINT `vehicles_ibfk_1` FOREIGN KEY (`assigned_driver_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert sample vehicles if the table is empty
INSERT INTO `vehicles` (`identifier`, `type`, `status`, `license_plate`, `assigned_driver_id`)
SELECT '101', 'Truck', 'in_use', 'ABC123', (SELECT id FROM users WHERE role = 'driver' LIMIT 1)
FROM dual
WHERE NOT EXISTS (SELECT 1 FROM vehicles LIMIT 1);

INSERT INTO `vehicles` (`identifier`, `type`, `status`, `license_plate`)
SELECT '102', 'Van', 'available', 'DEF456'
FROM dual
WHERE NOT EXISTS (SELECT 1 FROM vehicles LIMIT 1);

INSERT INTO `vehicles` (`identifier`, `type`, `status`, `license_plate`)
SELECT '103', 'Truck', 'maintenance', 'GHI789'
FROM dual
WHERE NOT EXISTS (SELECT 1 FROM vehicles LIMIT 1);

INSERT INTO `vehicles` (`identifier`, `type`, `status`, `license_plate`)
SELECT '104', 'SUV', 'out_of_service', 'JKL012'
FROM dual
WHERE NOT EXISTS (SELECT 1 FROM vehicles LIMIT 1);

INSERT INTO `vehicles` (`identifier`, `type`, `status`, `license_plate`, `assigned_driver_id`)
SELECT '105', 'Truck', 'in_use', 'MNO345', (SELECT id FROM users WHERE role = 'driver' LIMIT 1 OFFSET 1)
FROM dual
WHERE NOT EXISTS (SELECT 1 FROM vehicles LIMIT 1);

-- Create vehicle_locations table if it doesn't exist
CREATE TABLE IF NOT EXISTS `vehicle_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vehicle_id` int(11) NOT NULL,
  `latitude` decimal(10,6) NOT NULL,
  `longitude` decimal(10,6) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `vehicle_id` (`vehicle_id`),
  CONSTRAINT `vehicle_locations_ibfk_1` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert sample vehicle locations if the table is empty
INSERT INTO `vehicle_locations` (`vehicle_id`, `latitude`, `longitude`)
SELECT 
    v.id, 
    39.8283 + (RAND() * 5 - 2.5), 
    -98.5795 + (RAND() * 5 - 2.5)
FROM 
    vehicles v
WHERE 
    NOT EXISTS (SELECT 1 FROM vehicle_locations LIMIT 1);
