<?php
require_once '../db_connect.php'; // Include connection just in case

header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
// $user_email = $_SESSION['user_email'] ?? null; // Get email from session if possible
// if (!$user_id || $user_role !== 'dispatch') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    // Basic validation
    $subject = $data['subject'] ?? null;
    $name = $data['name'] ?? null; // Ideally get from session
    $email = $data['email'] ?? null; // Ideally get from session, or validate if provided
    $description = $data['description'] ?? null;
    $role = $data['role'] ?? 'dispatch'; 

    // Validate email if not getting from session
    if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
         http_response_code(400); 
         echo json_encode(['error' => 'Invalid or missing email address.']);
         exit();
    }

    if ($subject && $name && $description) { 
        
        // --- Placeholder for actual support request handling ---
        // 1. Store in a database table (e.g., `support_tickets`)
        /*
        $sql = "INSERT INTO support_tickets (subject, name, email, description, role, status, created_at) 
                VALUES (?, ?, ?, ?, ?, 'new', NOW())";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $stmt->bind_param("sssss", $subject, $name, $email, $description, $role); 
            $stmt->execute();
            $stmt->close();
        } else {
             error_log("Failed to prepare statement for support ticket: " . $conn->error);
        }
        */

        // 2. Send an email notification
        /*
        $to = "dispatch.support@visapp.com"; // Your dispatch support email
        $email_subject = "New Dispatch Support Request ($role): " . $subject;
        $headers = "From: no-reply@visapp.com\r\n";
        $headers .= "Reply-To: " . $email . "\r\n"; 
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        
        $email_body = "New dispatch support request received:\n\n";
        $email_body .= "From: " . $name . " (" . $email . ")\n";
        $email_body .= "Role: " . $role . "\n";
        $email_body .= "Subject: " . $subject . "\n\n";
        $email_body .= "Description:\n" . $description;

        // Use mail() function or a library
        // mail($to, $email_subject, $email_body, $headers); 
        */
        
        // For now, just return success
        echo json_encode(['success' => true, 'message' => 'Request received.']);
        
    } else {
        http_response_code(400); // Bad Request
        echo json_encode(['error' => 'Invalid or missing data. Please fill all required fields.']);
    }

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close(); // Close connection if it was used
?>