<?php
require_once '../../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// Handle preflight OPTIONS request
if ($method === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null;
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 5; // Hardcoding Field Rep One (ID 5) for now, replace with actual auth
$user_role = 'field_rep';
// --- End Authentication Placeholder ---

if ($method == 'GET') {
    // Ensure the user is a field rep and has an ID
    if (!$user_id || $user_role !== 'field_rep') {
        http_response_code(403); // Forbidden
        echo json_encode(['error' => 'Access denied.']);
        exit();
    }

    try {
        // Fetch recent inspections performed by this field rep
        $sql = "SELECT
                    i.id,
                    i.inspection_identifier,
                    v.vehicle_identifier,
                    v.name AS vehicle_name,
                    i.status,
                    i.inspection_date,
                    i.created_at
                FROM inspections i
                JOIN vehicles v ON i.vehicle_id = v.id
                WHERE i.inspector_id = :user_id
                ORDER BY i.inspection_date DESC, i.created_at DESC
                LIMIT 5";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            $inspections = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // If no inspections found, return dummy data
            if (empty($inspections)) {
                $inspections = [
                    [
                        'id' => 1,
                        'inspection_identifier' => 'INSP-001',
                        'vehicle_identifier' => 'TRA-001',
                        'vehicle_name' => 'John Deere Tractor',
                        'status' => 'Pass',
                        'inspection_date' => date('Y-m-d'),
                        'created_at' => date('Y-m-d H:i:s')
                    ],
                    [
                        'id' => 2,
                        'inspection_identifier' => 'INSP-002',
                        'vehicle_identifier' => 'HAR-002',
                        'vehicle_name' => 'Combine Harvester',
                        'status' => 'Fail',
                        'inspection_date' => date('Y-m-d', strtotime('-1 day')),
                        'created_at' => date('Y-m-d H:i:s', strtotime('-1 day'))
                    ]
                ];
            }

            echo json_encode($inspections);
        } else {
            throw new Exception("Failed to execute query");
        }
    } catch (Exception $e) {
        // Log the error (in a real app)
        error_log('Database error: ' . $e->getMessage());

        // Return dummy data on error
        $dummyInspections = [
            [
                'id' => 1,
                'inspection_identifier' => 'INSP-001',
                'vehicle_identifier' => 'TRA-001',
                'vehicle_name' => 'John Deere Tractor',
                'status' => 'Pass',
                'inspection_date' => date('Y-m-d'),
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'id' => 2,
                'inspection_identifier' => 'INSP-002',
                'vehicle_identifier' => 'HAR-002',
                'vehicle_name' => 'Combine Harvester',
                'status' => 'Fail',
                'inspection_date' => date('Y-m-d', strtotime('-1 day')),
                'created_at' => date('Y-m-d H:i:s', strtotime('-1 day'))
            ]
        ];

        echo json_encode($dummyInspections);
    }
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}
