<?php
require_once 'api.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $userId = validateToken();
        
        $stmt = $pdo->prepare("
            SELECT 
                t.id,
                t.task_identifier,
                t.type,
                t.description,
                t.status,
                t.priority,
                t.due_date,
                v.identifier as vehicle_identifier,
                y.name as yard_name
            FROM tasks t
            LEFT JOIN vehicles v ON t.vehicle_id = v.id
            LEFT JOIN yards y ON v.yard_id = y.id
            WHERE t.assigned_to = ? AND t.status != 'Completed'
            ORDER BY t.priority DESC, t.due_date ASC
        ");
        
        $stmt->execute([$userId]);
        $tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        if (empty($tasks)) {
            echo json_encode([
                'success' => true,
                'data' => []
            ]);
            exit;
        }
        
        echo json_encode([
            'success' => true,
            'data' => $tasks
        ]);
        
    } catch (Exception $e) {
        handleError($e->getMessage());
    }
} else {
    handleError('Method not allowed', 405);
}
?>
