<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Handle OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../../db_connect.php';

// Get data
$data = json_decode(file_get_contents("php://input"));

// Validate data
if (!isset($data->id) || !is_numeric($data->id)) {
    http_response_code(400);
    echo json_encode(array("error" => "Invalid defect ID provided."));
    exit();
}

// Sanitize input
$id = intval($data->id);

try {
    // Check database connection
    if (!isset($pdo) || !$pdo instanceof PDO) {
        throw new Exception("Database connection object not available.");
    }

    // Prepare delete statement
    $sql = "DELETE FROM defects WHERE id = :id";
    $stmt = $pdo->prepare($sql);

    // Bind parameters
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    // Execute the query
    if ($stmt->execute()) {
        if ($stmt->rowCount() > 0) {
            http_response_code(200);
            echo json_encode(array("message" => "Defect deleted successfully."));
        } else {
            http_response_code(404);
            echo json_encode(array("error" => "Defect not found."));
        }
    } else {
        http_response_code(503);
        echo json_encode(array("error" => "Unable to delete defect. Database error."));
    }
} catch (PDOException $e) {
    http_response_code(503);
    echo json_encode(array("error" => "Database connection error: " . $e->getMessage()));
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(array("error" => "An unexpected error occurred: " . $e->getMessage()));
} finally {
    $pdo = null;
}
?>
