<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, OPTIONS"); // Only GET is needed here
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Use the PDO connection established in db_connect.php
require_once '../../db_connect.php'; // Adjust path as needed, this should define $pdo
// Handle OPTIONS request for CORS preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Ensure $pdo is available
if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection is not available.']);
    exit();
}

// --- Authentication Placeholder ---
// In a real app, you'd verify the user's session/token and ensure they have owner privileges
// Example: validateToken($pdo); // Assuming validateToken function uses $pdo
// --- End Authentication Placeholder ---

// No specific input needed for this example (fetching all history)
// In a real app, you might want to add filtering options (by vehicle, date range, etc.)

$sql = "SELECT 
            i.id, 
            i.inspection_identifier,
            i.inspection_date, 
            i.status,
            i.findings,
            v.name AS vehicle_name, 
            v.plate AS vehicle_plate,
            u.name AS inspector_name, 
            it.name AS template_name
        FROM inspections i
        LEFT JOIN vehicles v ON i.vehicle_id = v.id
        LEFT JOIN users u ON i.inspector_id = u.id
        LEFT JOIN inspection_templates it ON i.template_id = it.id
        ORDER BY i.inspection_date DESC, i.id DESC"; 

try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute();

    // Fetch all results as an associative array
    $history = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Optional: Format date directly in PHP if needed, though frontend handles it
    // foreach ($history as &$record) {
    //     if (!empty($record['inspection_date'])) {
    //         try {
    //             $date = new DateTime($record['inspection_date']);
    //             $record['inspection_date'] = $date->format('Y-m-d'); // Format as needed
    //         } catch (Exception $e) {
    //             // Handle invalid date format if necessary, maybe set to null or keep original
    //             $record['inspection_date'] = null; // Or keep original $record['inspection_date']
    //         }
    //     }
    //     // Ensure inspector_name is set, default to 'N/A' if user was deleted/null
    //     $record['inspector_name'] = $record['inspector_name'] ?? 'N/A';
    // }
    // unset($record); // Unset reference

    echo json_encode(['success' => true, 'data' => $history]);

} catch (PDOException $e) {
    http_response_code(500);
    // Log the error server-side is better for production
    error_log("Database Error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Failed to retrieve inspection history. Please try again later.'. $e->getMessage()]); // User-friendly message
}

// No need to explicitly close PDO connection; it's handled by PHP
?>
