<?php
// Simple version of regional fleet status API with minimal dependencies and error handling

// Set headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Create a simple response for testing
$testResponse = [
    'summary' => [
        'totalVehicles' => 150,
        'operational' => 135,
        'inMaintenance' => 10,
        'outOfService' => 5
    ],
    'byYard' => [
        [
            'yard_name' => 'Yard Alpha',
            'operational_count' => 28,
            'maintenance_count' => 1,
            'out_of_service_count' => 1
        ],
        [
            'yard_name' => 'Yard Bravo',
            'operational_count' => 25,
            'maintenance_count' => 0,
            'out_of_service_count' => 0
        ],
        [
            'yard_name' => 'Yard Charlie',
            'operational_count' => 30,
            'maintenance_count' => 3,
            'out_of_service_count' => 2
        ],
        [
            'yard_name' => 'Yard Delta',
            'operational_count' => 32,
            'maintenance_count' => 4,
            'out_of_service_count' => 1
        ],
        [
            'yard_name' => 'Yard Echo',
            'operational_count' => 20,
            'maintenance_count' => 2,
            'out_of_service_count' => 1
        ]
    ],
    'attention' => [
        [
            'vehicle_identifier' => 'TRK-1001',
            'yard_name' => 'Yard Alpha',
            'issue_description' => 'Engine overheating during operation',
            'issue_priority' => 'High'
        ],
        [
            'vehicle_identifier' => 'TRK-1045',
            'yard_name' => 'Yard Charlie',
            'issue_description' => 'Brake fluid leak detected',
            'issue_priority' => 'Critical'
        ],
        [
            'vehicle_identifier' => 'TRK-1078',
            'yard_name' => 'Yard Delta',
            'issue_description' => 'Scheduled maintenance overdue by 2 weeks',
            'issue_priority' => 'Medium'
        ],
        [
            'vehicle_identifier' => 'TRK-1023',
            'yard_name' => 'Yard Bravo',
            'issue_description' => 'Tire pressure warning',
            'issue_priority' => 'Low'
        ]
    ]
];

// Return the test response
echo json_encode($testResponse);
?>
