<?php
// Simple version of regional overview API with minimal dependencies and error handling

// Set headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Create a simple response for testing
$testResponse = [
    'overview' => [
        'regionName' => 'Central Region',
        'totalYards' => 5,
        'totalVehicles' => 150,
        'activeDrivers' => 120,
        'complianceRate' => '95%'
    ],
    'yards' => [
        [
            'id' => 1,
            'name' => 'Yard Alpha',
            'status' => 'Operational',
            'vehicle_count' => 30,
            'pending_inspections' => 2
        ],
        [
            'id' => 2,
            'name' => 'Yard Bravo',
            'status' => 'Operational',
            'vehicle_count' => 25,
            'pending_inspections' => 0
        ],
        [
            'id' => 3,
            'name' => 'Yard Charlie',
            'status' => 'Partial Alert',
            'vehicle_count' => 35,
            'pending_inspections' => 5
        ],
        [
            'id' => 4,
            'name' => 'Yard Delta',
            'status' => 'Operational',
            'vehicle_count' => 40,
            'pending_inspections' => 1
        ],
        [
            'id' => 5,
            'name' => 'Yard Echo',
            'status' => 'Maintenance',
            'vehicle_count' => 20,
            'pending_inspections' => 3
        ]
    ]
];

// Return the test response
echo json_encode($testResponse);
?>
