<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
// $user_yard_id = $_SESSION['yard_id'] ?? null; // Wash crew might be tied to a yard
$user_id = 8; // Hardcoding Wash Crew One (ID 8) for now
$user_role = 'wash_crew'; 
// if (!$user_id || $user_role !== 'wash_crew') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'GET') {
    // Fetch Pending and In Progress wash jobs 
    // Optionally filter by yard if $user_yard_id is available
    $sql = "SELECT 
                wj.id AS wash_job_db_id, 
                wj.job_identifier, 
                wj.location_text, 
                wj.status, 
                wj.scheduled_time, 
                wj.start_time, 
                wj.notes,
                v.vehicle_identifier,
                vt.name AS vehicle_type_name
            FROM wash_jobs wj
            JOIN vehicles v ON wj.vehicle_id = v.id
            LEFT JOIN vehicle_types vt ON v.vehicle_type_id = vt.id
            WHERE wj.status IN ('Pending', 'In Progress') ";
            
    // Example filtering by yard:
    // if ($user_yard_id) {
    //     $sql .= " AND v.yard_id = ? "; // Assuming vehicles table has yard_id
    // }
    
    $sql .= " ORDER BY FIELD(wj.status, 'In Progress', 'Pending'), wj.scheduled_time ASC, wj.created_at ASC";
            
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    // If filtering by yard: $stmt->bind_param("i", $user_yard_id);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $schedule = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
             // Format times if needed
             if ($row['scheduled_time']) {
                 $dt = new DateTime($row['scheduled_time']);
                 $row['scheduled_time'] = $dt->format('Y-m-d H:i:s'); 
             }
             if ($row['start_time']) {
                 $dt = new DateTime($row['start_time']);
                 $row['start_time'] = $dt->format('Y-m-d H:i:s');
             }
            $schedule[] = $row;
        }
        echo json_encode($schedule);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} elseif ($method == 'POST') {
    // Handle starting or completing a job
     if ($user_role !== 'wash_crew') {
        http_response_code(403); 
        echo json_encode(['error' => 'Access denied.']);
        exit();
    }
    
    $data = json_decode(file_get_contents('php://input'), true);
    $action = $data['action'] ?? null; // 'start' or 'complete'
    $job_identifier = $data['job_identifier'] ?? null;

    if (!$job_identifier || !in_array($action, ['start', 'complete'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid action or missing job identifier.']);
        exit();
    }

    $new_status = null;
    $time_field = null;
    $current_status_check = null; // Status the job should be in before update

    if ($action == 'start') {
        $new_status = 'In Progress';
        $time_field = 'start_time';
        $current_status_check = 'Pending';
    } elseif ($action == 'complete') {
        $new_status = 'Completed';
        $time_field = 'completion_time';
        $current_status_check = 'In Progress';
    }

    // Update the job status and timestamp
    $sql = "UPDATE wash_jobs SET status = ?, {$time_field} = NOW() 
            WHERE job_identifier = ? AND status = ?";
            
    // Optionally add yard check: AND vehicle_id IN (SELECT id FROM vehicles WHERE yard_id = ?)
            
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare update statement: ' . $conn->error]);
        exit();
    }

    // Bind params: status, identifier, current_status
    // If adding yard check: status, identifier, current_status, yard_id
    $stmt->bind_param("sss", $new_status, $job_identifier, $current_status_check);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo json_encode(['success' => true, 'message' => "Job $job_identifier status updated to $new_status."]);
            // Optional: Update vehicle status if completing
            // if ($new_status == 'Completed') { /* Update vehicles table status to 'Ready' or similar */ }
        } else {
            // Check if the job exists but was already in the target state or wrong initial state
            http_response_code(409); // Conflict or Bad Request
            echo json_encode(['error' => "Job not found, or not in the correct state ('$current_status_check') to perform action '$action'."]);
        }
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to update job status: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>