<?php
require_once '../../db_connect.php'; // Corrected path to db_connect.php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];

// Assuming yard_id might be needed later, e.g., from session or request
// $yard_id = $_SESSION['yard_id'] ?? null; // Example: Get yard_id from session
$yard_id = 1; // Hardcoding for now based on dummy data structure, adjust as needed

if ($method == 'GET') {
    try {
        // Fetch vehicle status data with detailed information
        $sql = "SELECT 
                v.id, 
                v.vehicle_identifier, 
                v.status, 
                v.location_text, 
                v.maintenance_due_date,
                vt.name AS vehicle_type,
                y.name AS yard_name,
                u.name AS assigned_driver,
                (SELECT MAX(m.service_date) FROM maintenance m WHERE m.vehicle_id = v.id AND m.service_type = 'oil_change') AS last_oil_change,
                (SELECT MAX(m.service_date) FROM maintenance m WHERE m.vehicle_id = v.id AND m.service_type = 'tire_rotation') AS last_tire_rotation
            FROM vehicles v
            LEFT JOIN vehicle_types vt ON v.vehicle_type_id = vt.id
            LEFT JOIN yards y ON v.yard_id = y.id
            LEFT JOIN (
                SELECT va.vehicle_id, va.user_id
                FROM vehicle_assignments va
                WHERE va.status = 'active'
            ) current_va ON v.id = current_va.vehicle_id
            LEFT JOIN users u ON current_va.user_id = u.id";
        
        // Add yard filtering if needed
        if ($yard_id) {
            $sql .= " WHERE v.yard_id = ?";
            $params = [$yard_id];
        } else {
            $params = [];
        }
        
        // Prepare and execute the statement using PDO
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        
        // Fetch all results
        $vehicles = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Format dates for better readability
        foreach ($vehicles as &$vehicle) {
            if (!empty($vehicle['maintenance_due_date'])) {
                $vehicle['maintenance_due_date'] = date('Y-m-d', strtotime($vehicle['maintenance_due_date']));
            }
            if (!empty($vehicle['last_oil_change'])) {
                $vehicle['last_oil_change'] = date('Y-m-d', strtotime($vehicle['last_oil_change']));
            } else {
                $vehicle['last_oil_change'] = 'N/A';
            }
            if (!empty($vehicle['last_tire_rotation'])) {
                $vehicle['last_tire_rotation'] = date('Y-m-d', strtotime($vehicle['last_tire_rotation']));
            } else {
                $vehicle['last_tire_rotation'] = 'N/A';
            }
        }
        
        // Return the results as JSON
        echo json_encode($vehicles);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}
?>
