<?php
// Simple version of vehicle_status.php with minimal dependencies and error handling

// Database connection parameters
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'vehicle_inspection_system';

// Set headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Create a simple response for testing
$testResponse = [
    [
        'id' => 1,
        'vehicle_identifier' => 'TEST-001',
        'status' => 'Operational',
        'location_text' => 'Test Location',
        'maintenance_due_date' => '2023-12-31',
        'vehicle_type' => 'Tractor',
        'yard_name' => 'Main Yard',
        'assigned_driver' => 'Test Driver',
        'last_oil_change' => '2023-10-15',
        'last_tire_rotation' => '2023-09-01'
    ]
];

// Return the test response
echo json_encode($testResponse);
?>
