<?php
require_once 'config/database.php';

try {
    // Get all users
    $stmt = $pdo->query("SELECT id, pin FROM users");
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($users as $user) {
        // Assuming default PIN is '1234' - you'll need to adjust this based on your needs
        $defaultPin = '1234';
        // Generate SHA-256 hash
        $sha256Hash = hash('sha256', $defaultPin);
        
        // Update user's PIN
        $updateStmt = $pdo->prepare("UPDATE users SET pin = ? WHERE id = ?");
        $updateStmt->execute([$sha256Hash, $user['id']]);
    }

    echo "PIN hashes updated successfully\n";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}