<?php
// Database connection
require_once 'db_connect.php';

// Set content type to JSON
header('Content-Type: application/json');

try {
    // Check if user_identifier column exists
    $columnCheckStmt = $pdo->prepare("SHOW COLUMNS FROM users LIKE 'user_identifier'");
    $columnCheckStmt->execute();
    $columnExists = $columnCheckStmt->rowCount() > 0;
    
    if (!$columnExists) {
        // Add user_identifier column
        $alterStmt = $pdo->prepare("ALTER TABLE users 
                                    ADD COLUMN user_identifier varchar(50) DEFAULT NULL,
                                    ADD UNIQUE INDEX idx_user_identifier (user_identifier)");
        $alterStmt->execute();
        
        // Update existing users with generated identifiers
        $usersStmt = $pdo->query("SELECT id FROM users WHERE user_identifier IS NULL");
        $users = $usersStmt->fetchAll(PDO::FETCH_ASSOC);
        
        foreach ($users as $user) {
            $userIdentifier = 'U' . str_pad($user['id'], 4, '0', STR_PAD_LEFT);
            $updateStmt = $pdo->prepare("UPDATE users SET user_identifier = ? WHERE id = ?");
            $updateStmt->execute([$userIdentifier, $user['id']]);
        }
        
        echo json_encode(['success' => true, 'message' => 'Added user_identifier column to users table and updated existing users']);
    } else {
        echo json_encode(['success' => true, 'message' => 'user_identifier column already exists']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>