<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database connection
require_once 'db_connect.php';

// Get request method
$method = $_SERVER['REQUEST_METHOD'];

// Check for token in headers - disabled for testing
// $headers = getallheaders();
// $token = isset($headers['Authorization']) ? $headers['Authorization'] : '';

// Verify token (simplified for demo)
// In a production environment, implement proper JWT validation
// if (empty($token)) {
//     echo json_encode(['error' => 'Authentication required']);
//     exit;
// }

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

if ($method === 'GET') {
    try {
        // Query to fetch vehicles
        $sql = "SELECT
                    id,
                    vehicle_identifier,
                    make,
                    model,
                    year,
                    license_plate,
                    status
                FROM
                    vehicles
                WHERE
                    status = 'active'
                ORDER BY
                    vehicle_identifier ASC";

        $stmt = $pdo->prepare($sql);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $vehicles = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($vehicles);
        } else {
            // If no vehicles found, return empty array
            echo json_encode([]);
        }
    } catch (PDOException $e) {
        echo json_encode(['error' => 'Failed to fetch vehicles: ' . $e->getMessage()]);
    }
} elseif ($method === 'POST') {
    try {
        // Get POST data
        $data = json_decode(file_get_contents("php://input"), true);

        // Validate required fields
        $requiredFields = ['vehicle_identifier', 'make', 'model', 'year', 'license_plate'];
        foreach ($requiredFields as $field) {
            if (!isset($data[$field]) || empty($data[$field])) {
                echo json_encode(['error' => "Missing required field: $field"]);
                exit;
            }
        }

        // Insert new vehicle
        $sql = "INSERT INTO vehicles
                (vehicle_identifier, make, model, year, license_plate, status)
                VALUES (?, ?, ?, ?, ?, ?)";

        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $data['vehicle_identifier'],
            $data['make'],
            $data['model'],
            $data['year'],
            $data['license_plate'],
            $data['status'] ?? 'active'
        ]);

        echo json_encode([
            'success' => true,
            'message' => 'Vehicle created successfully',
            'id' => $pdo->lastInsertId()
        ]);
    } catch (PDOException $e) {
        echo json_encode(['error' => 'Failed to create vehicle: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['error' => 'Method not allowed']);
}
?>
