<?php
// Set CORS headers directly in this file
header("Access-Control-Allow-Origin: http://localhost:3000");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database connection
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'vehicle_inspection_system';

try {
    // Create PDO connection
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $dashboardData = array();
    
    // Get cleaning logs
    $cleaningLogsQuery = "
        SELECT wcl.*, v.vehicle_number 
        FROM wash_crew_logs wcl 
        JOIN vehicles v ON wcl.vehicle_id = v.id 
        ORDER BY wcl.created_at DESC 
        LIMIT 10
    ";
    $stmt = $pdo->query($cleaningLogsQuery);
    $dashboardData['cleaningLogs'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get pending instructions
    $instructionsQuery = "
        SELECT wci.*, v.vehicle_number 
        FROM wash_crew_instructions wci 
        JOIN vehicles v ON wci.vehicle_id = v.id 
        WHERE wci.status = 'pending' 
        ORDER BY wci.priority DESC, wci.created_at DESC
    ";
    $stmt = $pdo->query($instructionsQuery);
    $dashboardData['pendingInstructions'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get tasks for wash crew
    $tasksQuery = "
        SELECT * FROM tasks 
        WHERE assignee_id IN (
            SELECT id FROM users 
            WHERE role = 'wash_crew'
        ) 
        AND status != 'completed' 
        ORDER BY due_date ASC
    ";
    $stmt = $pdo->query($tasksQuery);
    $dashboardData['tasks'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get today's stats
    $today = date('Y-m-d');
    $statsQuery = "
        SELECT COUNT(*) as total_cleanings 
        FROM wash_crew_logs 
        WHERE DATE(created_at) = :today
    ";
    $stmt = $pdo->prepare($statsQuery);
    $stmt->execute(['today' => $today]);
    $todayStats = $stmt->fetch(PDO::FETCH_ASSOC);

    $dashboardData['stats'] = array(
        'totalCleaningsToday' => $todayStats['total_cleanings'],
        'pendingInstructions' => count($dashboardData['pendingInstructions']),
        'activeTasks' => count($dashboardData['tasks'])
    );

    echo json_encode([
        'success' => true,
        'data' => $dashboardData
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching dashboard data',
        'error' => $e->getMessage()
    ]);
}
?>


