<?php
// Simple version of washcrew users API with minimal dependencies and error handling

// Set headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Create a simple response for testing
$testResponse = [
    'success' => true,
    'data' => [
        [
            'id' => 101,
            'name' => 'John Washman',
            'email' => 'john.washman@example.com',
            'role' => 'washcrew',
            'status' => 'active',
            'created_at' => '2023-11-15 10:30:00',
            'created_by' => 3 // Yard Manager ID
        ],
        [
            'id' => 102,
            'name' => 'Sarah Cleaner',
            'email' => 'sarah.cleaner@example.com',
            'role' => 'washcrew',
            'status' => 'active',
            'created_at' => '2023-11-20 14:45:00',
            'created_by' => 3 // Yard Manager ID
        ],
        [
            'id' => 103,
            'name' => 'Mike Polisher',
            'email' => 'mike.polisher@example.com',
            'role' => 'washcrew',
            'status' => 'inactive',
            'created_at' => '2023-10-05 09:15:00',
            'created_by' => 3 // Yard Manager ID
        ],
        [
            'id' => 104,
            'name' => 'Lisa Detailer',
            'email' => 'lisa.detailer@example.com',
            'role' => 'washcrew',
            'status' => 'pending',
            'created_at' => '2023-12-01 11:20:00',
            'created_by' => 3 // Yard Manager ID
        ],
        [
            'id' => 105,
            'name' => 'David Washer',
            'email' => 'david.washer@example.com',
            'role' => 'washcrew',
            'status' => 'active',
            'created_at' => '2023-11-10 08:30:00',
            'created_by' => 3 // Yard Manager ID
        ]
    ]
];

// Return the test response
echo json_encode($testResponse);
?>
