<?php
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db_connect.php';

if (isset($_POST['task']) && isset($_POST['fieldRepId'])) {
    $task = $_POST['task'];
    $fieldRepId = $_POST['fieldRepId'];
    $status = 'pending';
    $yardManagerId = 1; // Placeholder

    $stmt = $conn->prepare("INSERT INTO field_rep_tasks (task, status, field_rep_id, yard_manager_id) VALUES (?, ?, ?, ?)");
    $stmt->execute([$task, $status, $fieldRepId, $yardManagerId]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(array('success' => true, 'message' => 'Task assigned successfully', 'data' => array('taskId' => $conn->lastInsertId())));
    } else {
        echo json_encode(array('success' => false, 'message' => 'Error assigning task'));
    }
} else {
    echo json_encode(array('success' => false, 'message' => 'Task and Field Rep ID are required'));
}