<?php
require_once '../db_connect.php';

header('Content-Type: application/json');

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

// Check if asset_id is provided
if (!isset($_GET['asset_id'])) {
    http_response_code(400); // Bad Request
    echo json_encode(['error' => 'Asset ID is required']);
    exit();
}

$assetId = $_GET['asset_id'];

// Mock assignment history data
$assignmentHistory = [
    1 => [
        [
            'id' => 1,
            'driver' => 'John Doe',
            'startDate' => '2023-01-15',
            'endDate' => null,
            'notes' => 'Primary driver'
        ]
    ],
    2 => [
        [
            'id' => 2,
            'driver' => 'Sarah Williams',
            'startDate' => '2023-02-10',
            'endDate' => null,
            'notes' => 'Long-haul assignments'
        ]
    ],
    3 => [
        [
            'id' => 3,
            'driver' => 'Chris Taylor',
            'startDate' => '2022-12-01',
            'endDate' => '2023-06-01',
            'notes' => 'Warehouse operations'
        ]
    ]
];

// Check if assignment history exists for the asset
if (!isset($assignmentHistory[$assetId])) {
    // Return empty array if no assignment history found
    echo json_encode(['success' => true, 'data' => []]);
    exit();
}

// Return the assignment history as JSON
echo json_encode(['success' => true, 'data' => $assignmentHistory[$assetId]]);

// Close the database connection
$conn->close();
?>
