<?php
require_once '../db_connect.php';

header('Content-Type: application/json');

// Check if the request method is DELETE
if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

// Check if ID is provided
if (!isset($_GET['id'])) {
    http_response_code(400); // Bad Request
    echo json_encode(['error' => 'Asset ID is required']);
    exit();
}

$id = $_GET['id'];

// In a real implementation, you would delete the asset from the database
// For now, we'll just return a success response

// Return success response
echo json_encode(['success' => true, 'message' => "Asset with ID $id has been deleted"]);

// Close the database connection
$conn->close();
?>
