<?php
require_once '../db_connect.php';

header('Content-Type: application/json');

// Mock data
$assets = [
    [
        'id' => 1,
        'name' => 'Truck 101',
        'assetType' => 'Truck',
        'status' => 'Available',
        'location' => 'Main Yard',
        'assignedDriver' => 'John Doe',
        'description' => 'Standard delivery truck',
        'lastInspectionDate' => '2023-05-15',
        'lastInspectionResult' => 'Pass',
        'faultsCount' => 0,
        'imageUrl' => 'https://picsum.photos/id/1072/400/300',
        'specifications' => [
            'make' => 'Ford',
            'model' => 'F-650',
            'year' => '2020',
            'fuelType' => 'Diesel',
            'engineType' => 'V8',
            'horsepower' => '330',
            'weight' => '26000',
            'capacity' => '10 tons'
        ],
        'dimensions' => [
            'length' => '26',
            'width' => '8',
            'height' => '13'
        ],
        'purchaseDate' => '2020-03-10',
        'purchasePrice' => '85000',
        'serialNumber' => 'FT65098342',
        'licensePlate' => 'TRK-1234',
        'vinNumber' => '1FDAF5GT8KEC74771',
        'lastUpdated' => '2023-06-01T14:30:00',
        'faults' => []
    ],
    [
        'id' => 2,
        'name' => 'Trailer 202',
        'assetType' => 'Trailer',
        'status' => 'In Service',
        'location' => 'Route 66',
        'assignedDriver' => 'Sarah Williams',
        'description' => 'Flatbed trailer',
        'lastInspectionDate' => '2023-04-20',
        'lastInspectionResult' => 'Pass with notes',
        'faultsCount' => 1,
        'imageUrl' => 'https://picsum.photos/id/1073/400/300',
        'specifications' => [
            'make' => 'Great Dane',
            'model' => 'Freedom Flatbed',
            'year' => '2019',
            'weight' => '14000',
            'capacity' => '48000 lbs'
        ],
        'dimensions' => [
            'length' => '48',
            'width' => '8.5',
            'height' => '4'
        ],
        'purchaseDate' => '2019-05-22',
        'purchasePrice' => '38000',
        'serialNumber' => 'GD48765123',
        'licensePlate' => 'TRL-5678',
        'vinNumber' => '1GRAA4238KT765432',
        'lastUpdated' => '2023-05-28T09:15:00',
        'faults' => [
            [
                'id' => 1,
                'reportDate' => '2023-05-28',
                'reportedBy' => 'Sarah Williams',
                'description' => 'Right rear light not working',
                'severity' => 'Minor',
                'status' => 'Open',
                'photos' => ['/assets/fault-light.jpg']
            ]
        ]
    ],
    [
        'id' => 3,
        'name' => 'Forklift 303',
        'assetType' => 'Equipment',
        'status' => 'Out of Service',
        'location' => 'Warehouse B',
        'assignedDriver' => null,
        'description' => 'Warehouse forklift',
        'lastInspectionDate' => '2023-03-05',
        'lastInspectionResult' => 'Fail',
        'faultsCount' => 3,
        'imageUrl' => 'https://picsum.photos/id/1074/400/300',
        'specifications' => [
            'make' => 'Toyota',
            'model' => '8FGU25',
            'year' => '2018',
            'fuelType' => 'Propane',
            'liftCapacity' => '5000 lbs',
            'maxLiftHeight' => '189 inches'
        ],
        'dimensions' => [
            'length' => '8',
            'width' => '4',
            'height' => '7'
        ],
        'purchaseDate' => '2018-11-15',
        'purchasePrice' => '32000',
        'serialNumber' => 'TFL87654321',
        'lastUpdated' => '2023-06-02T11:45:00',
        'faults' => [
            [
                'id' => 2,
                'reportDate' => '2023-06-01',
                'reportedBy' => 'Mark Wilson',
                'description' => 'Hydraulic lift not functioning properly',
                'severity' => 'Major',
                'status' => 'In Progress',
                'photos' => ['/assets/fault-hydraulic.jpg']
            ],
            [
                'id' => 3,
                'reportDate' => '2023-06-01',
                'reportedBy' => 'Mark Wilson',
                'description' => 'Oil leak under vehicle',
                'severity' => 'Major',
                'status' => 'Open',
                'photos' => ['/assets/fault-oil-leak.jpg']
            ],
            [
                'id' => 4,
                'reportDate' => '2023-05-30',
                'reportedBy' => 'Chris Taylor',
                'description' => 'Warning light on dashboard',
                'severity' => 'Minor',
                'status' => 'Open',
                'photos' => []
            ]
        ]
    ]
];

// Return the assets as JSON
echo json_encode(['success' => true, 'data' => $assets]);

// Close the database connection
$conn->close();
?>
