<?php
require_once '../db_connect.php';

header('Content-Type: application/json');

// Check if the request method is PUT
if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

// Check if ID is provided
if (!isset($_GET['id'])) {
    http_response_code(400); // Bad Request
    echo json_encode(['error' => 'Asset ID is required']);
    exit();
}

$id = $_GET['id'];

// Get the request body
$data = json_decode(file_get_contents('php://input'), true);

// Check if data is valid
if (!$data) {
    http_response_code(400); // Bad Request
    echo json_encode(['error' => 'Invalid request data']);
    exit();
}

// In a real implementation, you would update the data in the database
// For now, we'll just return a success response with the data
$updatedAsset = $data;
$updatedAsset['id'] = $id;
$updatedAsset['lastUpdated'] = date('Y-m-d\TH:i:s');

// Return the updated asset as JSON
echo json_encode(['success' => true, 'data' => $updatedAsset]);

// Close the database connection
$conn->close();
?>
