<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
// if (!$user_id || $user_role !== 'dispatch') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'GET') {
    // Fetch all assignments, joining with users and vehicles
    // Consider adding pagination for large datasets
    $sql = "SELECT 
                da.id AS dispatch_assignment_db_id, 
                da.assignment_identifier, 
                da.type, 
                da.origin_location, 
                da.destination_location, 
                da.status, 
                da.scheduled_time, 
                da.start_time, 
                da.completion_time,
                u.name AS driver_name,
                u.user_identifier AS driver_identifier,
                v.vehicle_identifier
            FROM dispatch_assignments da
            JOIN users u ON da.driver_id = u.id
            JOIN vehicles v ON da.vehicle_id = v.id
            ORDER BY 
                CASE da.status
                    WHEN 'Active' THEN 1
                    WHEN 'Pending' THEN 2
                    WHEN 'Completed' THEN 3
                    ELSE 4
                END, 
                da.scheduled_time ASC, 
                da.start_time ASC, 
                da.created_at DESC";
            
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    // No parameters to bind in this example

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $assignments = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
             // Format dates/times if needed (e.g., remove seconds)
             if ($row['scheduled_time']) {
                 $dt = new DateTime($row['scheduled_time']);
                 $row['scheduled_time'] = $dt->format('Y-m-d H:i'); 
             }
             if ($row['start_time']) {
                 $dt = new DateTime($row['start_time']);
                 $row['start_time'] = $dt->format('Y-m-d H:i');
             }
              if ($row['completion_time']) {
                 $dt = new DateTime($row['completion_time']);
                 $row['completion_time'] = $dt->format('Y-m-d H:i');
             }
            $assignments[] = $row;
        }
        echo json_encode($assignments);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} elseif ($method == 'POST') {
    // Placeholder for creating/updating assignments
    http_response_code(501); // Not Implemented
    echo json_encode(['error' => 'POST method not implemented yet.']);

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>