<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 2; // Hardcoding Driver Alice Brown (ID 2) for now, replace with actual auth
$user_role = 'driver'; 
// if (!$user_id || $user_role !== 'driver') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'GET') {
     // Ensure the user is a driver and has an ID
    if (!$user_id || $user_role !== 'driver') {
        http_response_code(403); // Forbidden
        echo json_encode(['error' => 'Access denied.']);
        exit();
    }

    // Fetch assignments for this driver
    $sql = "SELECT 
                da.id AS dispatch_assignment_db_id, 
                da.assignment_identifier, 
                da.type, 
                da.origin_location, 
                da.destination_location, 
                da.status, 
                da.scheduled_time, 
                da.start_time, 
                da.completion_time
                -- Add estimated_duration and eta if available in dispatch_assignments or another table
                -- 'N/A' AS estimated_duration, -- Placeholder
                -- 'N/A' AS eta -- Placeholder
            FROM dispatch_assignments da
            WHERE da.driver_id = ?
            ORDER BY 
                CASE da.status
                    WHEN 'Active' THEN 1
                    WHEN 'Upcoming' THEN 2 -- Assuming 'Upcoming' is the same as 'Pending' for drivers
                    WHEN 'Pending' THEN 2 
                    WHEN 'Completed' THEN 3
                    ELSE 4
                END, 
                da.scheduled_time ASC, 
                da.start_time ASC, 
                da.created_at DESC";
            
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    $stmt->bind_param("i", $user_id);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $routes = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
             // Format dates/times if needed
             if ($row['scheduled_time']) {
                 $dt = new DateTime($row['scheduled_time']);
                 $row['scheduled_time'] = $dt->format('Y-m-d H:i:s'); // Keep standard format for potential sorting
             }
             if ($row['start_time']) {
                 $dt = new DateTime($row['start_time']);
                 $row['start_time'] = $dt->format('Y-m-d H:i:s');
             }
              if ($row['completion_time']) {
                 $dt = new DateTime($row['completion_time']);
                 $row['completion_time'] = $dt->format('Y-m-d H:i:s');
             }
             // Add placeholders if needed
             $row['estimated_duration'] = $row['estimated_duration'] ?? 'N/A';
             $row['eta'] = $row['eta'] ?? 'N/A';
             
            $routes[] = $row;
        }
        echo json_encode($routes);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>