<?php
require_once '../db_connect.php'; // Include connection just in case

header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
// $user_email = $_SESSION['user_email'] ?? null; // Get email from session if possible
// if (!$user_id || $user_role !== 'field_rep') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    // Basic validation
    $subject = $data['subject'] ?? null;
    $taskId = $data['taskId'] ?? null; // Optional Task ID
    $name = $data['name'] ?? null; // Ideally get from session
    // $email = $user_email ?? null; // Ideally get from session
    $description = $data['description'] ?? null;
    $role = $data['role'] ?? 'field_rep'; 

    // Add email validation if not getting from session
    // if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) { /* Handle invalid email */ }

    if ($subject && $name && $description) { // Removed email check if getting from session
        
        // --- Placeholder for actual support request handling ---
        // 1. Store in a database table (e.g., `support_tickets`)
        /*
        $sql = "INSERT INTO support_tickets (subject, name, email, description, role, related_task_id, status, created_at) 
                VALUES (?, ?, ?, ?, ?, ?, 'new', NOW())";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            // Assuming email is fetched from session/auth
            $stmt->bind_param("ssssss", $subject, $name, $user_email, $description, $role, $taskId); 
            $stmt->execute();
            $stmt->close();
        } else {
             error_log("Failed to prepare statement for support ticket: " . $conn->error);
        }
        */

        // 2. Send an email notification
        /*
        $to = "tech.support@visapp.com"; // Your tech support email
        $email_subject = "New Field Rep Support Request ($role): " . $subject;
        $headers = "From: no-reply@visapp.com\r\n";
        // $headers .= "Reply-To: " . $user_email . "\r\n"; // Use session email
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        
        $email_body = "New field rep support request received:\n\n";
        $email_body .= "From: " . $name . "\n"; // Name might also come from session
        // $email_body .= "Email: " . $user_email . "\n";
        $email_body .= "Role: " . $role . "\n";
        if ($taskId) {
             $email_body .= "Related Task ID: " . $taskId . "\n";
        }
        $email_body .= "Subject: " . $subject . "\n\n";
        $email_body .= "Description:\n" . $description;

        // Use mail() function or a library
        // mail($to, $email_subject, $email_body, $headers); 
        */
        
        // For now, just return success
        echo json_encode(['success' => true, 'message' => 'Request received.']);
        
    } else {
        http_response_code(400); // Bad Request
        echo json_encode(['error' => 'Invalid or missing data. Please fill all required fields.']);
    }

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close(); // Close connection if it was used
?>